 ; Ŀ
 ;   Nch - change subentity data directly.                                 
 ;   Copyright 1994 by Rocket Software                                     
 ;   The more complex the task, the further you can get before             
 ;   discovering that you don't know what you're doing.                    
 ; 
 (DEFUN C:NCH (/ aa namlst outlst as au zz len num pos enam entt xx rr)
   (command "undo" "mark")
 ; Ŀ
 ;   Use a list rather than a selection set - Autolisp won't add an ename  
 ;   representing part of the block tables to an ss.                       
 ; 
   (while (setq aa (nentsel))
          (princ (cdr (assoc 0 (entget (car aa)))))
          (setq outer (car (reverse (car (reverse aa)))))
          (setq aa (list (car aa) outer))
          (if (not (member aa namlst))
              (setq namlst (append namlst (list aa)))
              (prompt "Already have that one.")))
 ; Ŀ
 ;   Print the data for the first ename as an example.                     
 ; 
   (if namlst 
       (progn
            (print (entget (car (nth 0 namlst))))
 ; Ŀ
 ;   Now ask the user what he wants to do.                                 
 ; 
            (setq as (getint "\nAssociation number to replace: "))
            (if (>= 9 as)
                (setq au (getstring T "New (string) value: ")))
            (if (and (<= 10 as) (>= 37 as))
                (setq au (getpoint "New point: ")))
            (if (and (<= 38 as) (>= 59 as))
                (setq au (getreal "New (real number) value: ")))
            (if (and (<= 60 as) (>= 79 as))
                (setq au (getint "New (integer) value: ")))a
            (if (and (<= 210 as) (>= 239 as))
                (setq au (getpoint "New point: ")))
            (if (= 999 as)
                (setq au (getstring T "New (string) value: ")))
            (if (null au) (setq au "xxx"))
            (setq zz (cons as au))
 ; Ŀ
 ;   Initialize counters.                                                  
 ; 
            (setq len (length namlst))
            (setq num 0)
 ; Ŀ
 ;   Make the changes.                                                     
 ; 
            (setq pos 0)
            (while (setq sub (nth pos namlst))
                   (setq enam (car sub))
                   (setq outer (cadr sub))
                   (setq pos (1+ pos))
                   (setq entt (entget enam))
                   (if (setq xx (assoc as entt))
                       (setq rr (entmod (subst zz xx entt)))
                       (setq rr (entmod (append entt (list zz)))))
                   (if rr 
                      (progn
                           (setq num (1+ num))
                           (entupd enam)
                           (if (and (= (type outer) 'ENAME)
                                    (null (member outer outlst)))
                               (setq outlst (append outlst (list outer)))))))
 ; Ŀ
 ;   Update everything that had subentities changed.                       
 ; 
            (if outlst
                (progn
                     (setq pos 0)
                     (while (setq sub (nth pos outlst))
                            (entupd sub)
                            (setq pos (1+ pos)))))))
 ; Ŀ
 ;   And explain what has been done.                                       
 ; 
   (if (> len 0)
       (prompt (strcat (itoa len) " selection" (if (= len 1) ", " "s, ")
                       (itoa num) " change" (if (= num 1) "" "s")
                       (if (/= len num)
                           (strcat ", " (itoa (- len num))
                                   " failed modification"
                                   (if (= (- len num) 1) "." "s."))
                           ".")))
       (prompt "\nNothing selected."))
 (princ))